package gov.va.med.mhv.usermgmt.main.service.impl;


import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActionTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.ActivityTypeEnumeration;
import gov.va.med.mhv.usermgmt.data.model.UserPasswordHistory;
import gov.va.med.mhv.usermgmt.data.repository.UserPasswordHistoryRepository;
import gov.va.med.mhv.usermgmt.main.service.validator.UserProfileValidator;
import gov.va.med.mhv.usermgmt.persist.ldap.spring.UserSpringLDAPDaoImpl;
import gov.va.med.mhv.usermgmt.service.ActivityService;
import gov.va.med.mhv.usermgmt.service.UserPasswordService;

@Component
public class UserPasswordServiceImpl implements UserPasswordService {
	
	protected static Logger log = LogManager.getLogger(UserPasswordServiceImpl.class);
	
	@Autowired
	private UserSpringLDAPDaoImpl userSpringLDAPDaoImpl;
	
	@Autowired
	private ActivityService activityService;
	
	@Autowired
	private UserProfileValidator validator;
	
	
	@Autowired
	private UserPasswordHistoryRepository passwordHistoryRepository;

	@Override
	public void changePassword(UserProfileDTO userProfileDTO, ResponseUtil response, Boolean isForgotPassword) {
		if( response.getValidationErrors() == null ) {
			response.setValidationErrors(new LinkedHashMap<String,String>());
		}
		validator.validatePassword(userProfileDTO, response.getValidationErrors());
		//TODO as part of the validation, you need to confirm the old password is correct.
		
		if( response.getValidationErrors() != null && response.getValidationErrors().isEmpty() ) {
//			emergencyContactRepository.save(e);
			
			userSpringLDAPDaoImpl.resetPassword(userProfileDTO.getUserName(), userProfileDTO.getPassword());
			response.setFailure(false);
			response.setSuccess(true);
			//SUCCESS 
			if(isForgotPassword) {
				activityService.createUserActivity(Boolean.TRUE,ActivityActionTypeEnumeration.RESET.getDescription(),ActivityTypeEnumeration.PASSWORD.getDescription(),response, userProfileDTO.getId());
			}else {
				activityService.createUserActivity(Boolean.TRUE,ActivityActionTypeEnumeration.PASSWORD_CHANGED.getDescription(),ActivityTypeEnumeration.PASSWORD.getDescription(),response,userProfileDTO.getId());
			}
		} else {
			//FAILURE
			if(isForgotPassword) {
				activityService.createUserActivity(Boolean.FALSE,ActivityActionTypeEnumeration.RESET.getDescription(),ActivityTypeEnumeration.PASSWORD.getDescription(),response,userProfileDTO.getId());
			}else {
				activityService.createUserActivity(Boolean.FALSE,ActivityActionTypeEnumeration.PASSWORD_CHANGED.getDescription(),ActivityTypeEnumeration.PASSWORD.getDescription(),response,userProfileDTO.getId());
			}
			response.setFailure(true);
			response.setSuccess(false);
			return;
		}
	}

	@Override
	public void checkPassword(UserProfileDTO userProfileDTO, ResponseUtil response) {
		boolean checked = userSpringLDAPDaoImpl.checkPassword(userProfileDTO.getUserName(), userProfileDTO.getPassword());
		response.setFailure(!checked);
		response.setSuccess(checked);
	}

	@Override
	public Boolean isTempPasswdExpired(Long userProfileId) {
		Boolean passWordExpired = false;
		List<UserPasswordHistory> prevPasswords =passwordHistoryRepository.getPreviousPasswords(userProfileId);
		if(prevPasswords != null && prevPasswords.size() > 0){
			UserPasswordHistory lastPassword = prevPasswords.get(0);
			if(lastPassword.getTempPasswordFlag()){
				Date currentDate = getCurrentDate();
				Date ExpiredDate = getExpiredDate(lastPassword.getUpdatedTime());
				if(currentDate.after(ExpiredDate)){
					passWordExpired=true;
				}
			}
		}
		return passWordExpired;
	}

	private Date getCurrentDate() {
		Calendar cal = Calendar.getInstance();
		cal.setTime(new Date());
		cal.set(Calendar.HOUR, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		return cal.getTime();
	}
	
	private Date getExpiredDate(Date updatedTime){
		Calendar cal = Calendar.getInstance();
		cal.setTime(updatedTime);
		cal.set(Calendar.HOUR, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		cal.add(Calendar.DATE, 2);
		return cal.getTime();
	}

	@Override
	public Boolean isLatestPasswordInHistTableTemporay(Long userProfileId) {
		Boolean tempPassword = false;
		List<UserPasswordHistory> prevPasswords =passwordHistoryRepository.getPreviousPasswords(userProfileId);
		if(prevPasswords != null && prevPasswords.size() > 0){
			tempPassword =prevPasswords.get(0).getTempPasswordFlag();
		}
		return tempPassword;
	}
}
